%--------------------------------------------------------------------------
% File     : HEN005=LeTrans-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : The relation less_equal is transitive
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H5 [McCharen, et al., 1976]
%          : hp5.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   22 (   0 non-Horn)(   7 unit)
%            Number of literals          :   49 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   5 constant)
%            Number of variables         :   55 (   3 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(xLEy,hypothesis,
    [++less_equal(x,y)]).

input_clause(yLEz,hypothesis,
    [++less_equal(y,z)]).

input_clause(prove_transitivity_of_less_equal,theorem,
    [--less_equal(x,z)]).
%--------------------------------------------------------------------------
