%--------------------------------------------------------------------------
% File     : HEN004=XDiv0-6 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X/zero = X
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H4 [McCharen, et al., 1976]
%          : hp4.ver2.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   17 (   0 non-Horn)(   8 unit)
%            Number of literals          :   30 (  18 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   33 (   5 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(everything_divide_id_is_zero,axiom,
    [++equal(divide(X,identity),zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++equal(divide(zero,X),zero)]).

input_clause(prove_x_divide_zero_is_x,theorem,
    [--equal(divide(a,zero),a)]).
%--------------------------------------------------------------------------
