%--------------------------------------------------------------------------
% File     : HEN004=XDiv0-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X/zero = X
% Version  : [McCharen, et al., 1976] (equality) axioms :
%            Reduced & Augmented > Complete.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H4 [McCharen, et al., 1976]
%          : hp4.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   7 unit)
%            Number of literals          :   19 (  19 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   22 (   3 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : less_equal replaced by divides
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms, for the equality formulation with 
%----less_equals removed.
include('Axioms/HEN003-0.ax').
%--------------------------------------------------------------------------
input_clause(x_divide_x_is_zero,axiom,
    [++equal(divide(X,X),zero)]).

input_clause(prove_x_divide_zero_is_x,theorem,
    [--equal(divide(a,zero),a)]).
%--------------------------------------------------------------------------
