%--------------------------------------------------------------------------
% File     : HEN004=XDiv0-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : X/zero = X
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H4 [McCharen, et al., 1976]
%          : hp4.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   23 (   0 non-Horn)(   8 unit)
%            Number of literals          :   50 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   58 (   5 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
%----McCharen uses these earlier results too. I don't 
input_clause(everything_divide_identity_is_zero,axiom,
    [++quotient(X,identity,zero)]).

input_clause(zero_divide_anything_is_zero,axiom,
    [++quotient(zero,X,zero)]).

input_clause(x_divide_x_is_zero,axiom,
    [++quotient(X,X,zero)]).

input_clause(prove_x_divde_zero_is_x,theorem,
    [--quotient(x,zero,x)]).
%--------------------------------------------------------------------------
