%--------------------------------------------------------------------------
% File     : HEN002=0DivX-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : zero/X = zero
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : H2 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   7 unit)
%            Number of literals          :   29 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   32 (   4 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms for equality formulation 
include('Axioms/HEN002-0.ax').
include('Axioms/HEN002-0.eq').
%--------------------------------------------------------------------------
input_clause(everything_divide_id_is_zero,axiom,
    [++equal(divide(X,identity),zero)]).

input_clause(prove_zero_over_a_is_zero,theorem,
    [--equal(divide(zero,a),zero)]).
%--------------------------------------------------------------------------
