%--------------------------------------------------------------------------
% File     : HEN002=0DivX-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Henkin Models
% Problem  : zero/X = zero
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : H2 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   6 unit)
%            Number of literals          :   48 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   56 (   4 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Henkin model axioms 
include('Axioms/HEN001-0.ax').
%----Include Henkin model equality axioms 
include('Axioms/HEN001-0.eq').
%--------------------------------------------------------------------------
%----McCharen uses this earlier result too. I don't 
input_clause(everything_divide_identity_is_zero,axiom,
    [++quotient(X,identity,zero)]).

input_clause(prove_zero_divide_anything_is_zero,theorem,
    [--quotient(zero,x,zero)]).
%--------------------------------------------------------------------------
