%--------------------------------------------------------------------------
% File     : GRP113=O4Eqn-1 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Group Theory
% Problem  : Lemma for proving all groups of order 4 are cyclic
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : Prove that any group of order 4 must satisfy one of the 
%            following relations, where the elements of the group are 
%            a, b, c, and the identity.
%            1) the square of every element is the identity.
%            2) the square of a is b, the cube of a is c, and the fourth
%               power of a is the identity.
%            3) the square of b is c, the cube of b is a, and the fourth
%               power of b is the identity.
%            4) the square of c is a, the cube of c is b, and the fourth

% Refs     : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
% Source   : [Wos, 1988]
% Names    : Test Problem 7 [Wos, 1988]
%          : Groups of Order 4 [Wos, 1988]

% Status   : 
% Syntax   : Number of clauses           :   22 (   1 non-Horn)(  12 unit)
%            Number of literals          :   39 (  39 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include the axioms for named groups 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
input_clause(all_of_group1,hypothesis,
    [++equal(X,a),
     ++equal(X,b),
     ++equal(X,c),
     ++equal(X,identity)]).

input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

input_clause(a_not_c,hypothesis,
    [--equal(a,c)]).

input_clause(a_not_identity,hypothesis,
    [--equal(a,identity)]).

input_clause(b_not_c,hypothesis,
    [--equal(b,c)]).

input_clause(b_not_identity,hypothesis,
    [--equal(b,identity)]).

input_clause(c_not_identity,hypothesis,
    [--equal(c,identity)]).

input_clause(square_identity,theorem,
    [--equal(multiply(a,a),identity),
     --equal(multiply(b,b),identity),
     --equal(multiply(c,c),identity)]).

input_clause(condition_a,theorem,
    [--equal(multiply(a,a),b),
     --equal(multiply(a,multiply(a,a)),c),
     --equal(multiply(a,multiply(a,multiply(a,a))),identity)]).

input_clause(condition_b,theorem,
    [--equal(multiply(b,b),c),
     --equal(multiply(b,multiply(b,b)),a),
     --equal(multiply(b,multiply(b,multiply(b,b))),identity)]).

input_clause(condition_c,theorem,
    [--equal(multiply(c,c),a),
     --equal(multiply(c,multiply(c,c)),b),
     --equal(multiply(c,multiply(c,multiply(c,c))),identity)]).
%--------------------------------------------------------------------------
