%--------------------------------------------------------------------------
% File     : GRP112=ProdInvAx15-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Single axiom for group theory, in product & inverse
% Version  : [McCune, 1993] (equality) axioms.
% English  : This is a single axiom for groups in which the square 
%            of every element is the identity, in terms of product and 
%            inverse.

% Refs     : Meredith C.A. and Prior A.N. (1968), Equational Logic, Notre 
%            Dame Journal of Formal Logic 9, 212-226.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
%          : McCune W.W. (1993), Single Axioms for Groups and Abelian 
%            Groups with Various Operations, Journal of Automated 
%            Reasoning 10(1), 1-13.
% Source   : [McCune, 1993]
% Names    : GT2 [Lusk & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   2 unit)
%            Number of literals          :   16 (  16 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   7 constant)
%            Number of variables         :   17 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    7

% Comments : The group axioms that are proved are different from those 
%            given in [Lusk & Wos, 1992]. Rather those suggested 
%            in [McCune, 1993] are used.
%          : Not sure if would be equivalent to show that the group 
%            is commutative. If the square of every element is the 
%            identity then commutativity follows, but maybe not vice 
%            versa.
%          : In general, I'm not sure if this is OK.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(single_axiom,axiom,
    [++equal(multiply(multiply(multiply(X,Y),Z),multiply(X,Z)),Y)]).

%----Substitution axioms 
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(prove_these_axioms,theorem,
    [--equal(multiply(inverse(a1),a1),multiply(inverse(b1),b1)),
     --equal(multiply(multiply(inverse(b2),b2),a2),a2),
     --equal(multiply(multiply(a3,b3),c3),multiply(a3,multiply(b3,c3))),
     --equal(multiply(a4,a4),multiply(b4,b4))]).
%--------------------------------------------------------------------------
