%--------------------------------------------------------------------------
% File     : GRP087=ProdInvAbnAx4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Abelian)
% Problem  : Single axiom for Abelian group theory, in product and inverse
% Version  : [McCune, 1993] (equality) axioms.
% English  : This is a single axiom for Abelian group theory, in terms 
%            of product and inverse.

% Refs     : McCune W.W. (1993), Single Axioms for Groups and Abelian 
%            Groups with Various Operations, Journal of Automated 
%            Reasoning 10(1), 1-13.
% Source   : [McCune, 1993]
% Names    : Axiom 3.7.3 [McCune, 1993]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   2 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   7 constant)
%            Number of variables         :   19 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(single_axiom,axiom,
    [++equal(multiply(X,multiply(multiply(inverse(multiply(X,Y)),Z),Y)),Z)]).

%----Substitution axioms 
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(prove_these_axioms,theorem,
    [--equal(multiply(inverse(a1),a1),multiply(inverse(b1),b1)),
     --equal(multiply(multiply(inverse(b2),b2),a2),a2),
     --equal(multiply(multiply(a3,b3),c3),multiply(a3,multiply(b3,c3))),
     --equal(multiply(X,Y),multiply(Y,X))]).
%--------------------------------------------------------------------------
