%--------------------------------------------------------------------------
% File     : GRP080=DblDivIdAx6-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Single axiom for group theory, in double division and identity
% Version  : [McCune, 1993] (equality) axioms.
% English  : This is a single axiom for group theory, in terms of double 
%            division and identity.

% Refs     : McCune W.W. (1993), Single Axioms for Groups and Abelian 
%            Groups with Various Operations, Journal of Automated 
%            Reasoning 10(1), 1-13.
% Source   : [McCune, 1993]
% Names    : Axiom 3.5.5 [McCune, 1993]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   4 unit)
%            Number of literals          :   22 (  22 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   11 (   8 constant)
%            Number of variables         :   26 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(single_axiom,axiom,
    [++equal(double_divide(double_divide(identity,double_divide(X,
double_divide(Y,identity))),double_divide(double_divide(Y,
double_divide(Z,X)),identity)),Z)]).

%----Definition of double division 
input_clause(double_division,axiom,
    [++equal(double_divide(X,Y),multiply(inverse(X),inverse(Y)))]).

%----Definition of identity 
input_clause(identity,axiom,
    [++equal(identity,double_divide(X,inverse(X)))]).

%----Substitution axioms 
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(double_divide_substitution1,axiom,
    [--equal(X,Y),
     ++equal(double_divide(X,W),double_divide(Y,W))]).

input_clause(double_divide_substitution2,axiom,
    [--equal(X,Y),
     ++equal(double_divide(W,X),double_divide(W,Y))]).

input_clause(prove_these_axioms,theorem,
    [--equal(multiply(inverse(a1),a1),multiply(inverse(b1),b1)),
     --equal(multiply(multiply(inverse(b2),b2),a2),a2),
     --equal(multiply(multiply(a3,b3),c3),multiply(a3,multiply(b3,c3)))]).
%--------------------------------------------------------------------------
