%--------------------------------------------------------------------------
% File     : GRP064=DivAx2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Single axiom for group theory, in division
% Version  : [McCune, 1993] (equality) axioms.
% English  : This is a single axiom for group theory, in terms of division

% Refs     : McCune W.W. (1993), Single Axioms for Groups and Abelian 
%            Groups with Various Operations, Journal of Automated 
%            Reasoning 10(1), 1-13.
% Source   : [McCune, 1993]
% Names    : Axiom 3.2.1 [McCune, 1993]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   3 unit)
%            Number of literals          :   21 (  21 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   7 constant)
%            Number of variables         :   25 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(single_axiom,axiom,
    [++equal(divide(X,divide(divide(divide(divide(Y,Y),Y),Z),divide(divide(
divide(Y,Y),X),Z))),Y)]).

%----Definition of division 
input_clause(division,axiom,
    [++equal(divide(X,Y),multiply(X,inverse(Y)))]).

%----Substitution axioms 
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(multiply_substitution1,axiom,
    [--equal(X,Y),
     ++equal(multiply(X,W),multiply(Y,W))]).

input_clause(multiply_substitution2,axiom,
    [--equal(X,Y),
     ++equal(multiply(W,X),multiply(W,Y))]).

input_clause(divide_substitution1,axiom,
    [--equal(X,Y),
     ++equal(divide(X,W),divide(Y,W))]).

input_clause(divide_substitution2,axiom,
    [--equal(X,Y),
     ++equal(divide(W,X),divide(W,Y))]).

input_clause(prove_these_axioms,theorem,
    [--equal(multiply(inverse(a1),a1),multiply(inverse(b1),b1)),
     --equal(multiply(multiply(inverse(b2),b2),a2),a2),
     --equal(multiply(multiply(a3,b3),c3),multiply(a3,multiply(b3,c3)))]).
%--------------------------------------------------------------------------
