%--------------------------------------------------------------------------
% File     : GRP040=SubGO2InvIvln-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups of order 2, inverse is an involution
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   29 (   2 non-Horn)(  12 unit)
%            Number of literals          :   60 (  22 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :   64 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
%----Definition of subgroup of index 2 
input_clause(an_element_in_O2,axiom,
    [++subgroup_member(element_in_O2(A,B)),
     ++subgroup_member(B),
     ++subgroup_member(A)]).

input_clause(property_of_O2,axiom,
    [++product(A,element_in_O2(A,B),B),
     ++subgroup_member(B),
     ++subgroup_member(A)]).

%----Extra substitution axiom 
input_clause(element_in_O2_substitution1,axiom,
    [--equal(A,B),
     ++equal(element_in_O2(C,A),element_in_O2(C,B))]).

input_clause(element_in_O2_substitution2,axiom,
    [--equal(A,B),
     ++equal(element_in_O2(A,C),element_in_O2(B,C))]).

input_clause(a_in_subgroup,hypothesis,
    [--subgroup_member(a)]).

input_clause(b_is_in_subgroup,hypothesis,
    [++subgroup_member(b)]).

input_clause(d_in_subgroup,hypothesis,
    [--subgroup_member(d)]).

input_clause(b_times_a_inverse_is_c,hypothesis,
    [++product(b,inverse(a),c)]).

input_clause(a_times_c_is_d,hypothesis,
    [++product(a,c,d)]).

input_clause(prove_inverse_is_self_cancelling,theorem,
    [++equal(inverse(inverse(A)),A)]).
%--------------------------------------------------------------------------
