%--------------------------------------------------------------------------
% File     : GRP039=SubGI2Norm-7 : TPTP v1.1.1. Bugfixed v1.0.1.
% Domain   : Group Theory (Subgroups)
% Problem  : Subgroups of index 2 are normal
% Version  : [McCharen, et al., 1976] (equality) axioms : Augmented.
% English  : If O is a subgroup of G and there are exactly 2 cosets 
%            in G/O, then O is normal [that is, for all x in G and 
%            y in O, x*y*inverse(x) is back in O].

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [McCharen, et al., 1976]
% Names    : GP2 [McCharen, et al., 1976]

% Status   : unsatisfiable
% Syntax   : Number of clauses           :   29 (   2 non-Horn)(  17 unit)
%            Number of literals          :   47 (  32 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :   42 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : Used to define a subgroup of index two is a theorem which 
%            says that {for all x, for all y, there exists a z such that 
%            if x and y are both not in the subgroup O, then z is in O and 
%            x*z=y} if & only if {O has index 2 in G}. This z is named 
%            by the skolem function i(x,y). Explanation: If O is of index 
%            two in G, then there are exactly two cosets, namely O and 
%            uO for some u not in O. If both of x and y are not in O, then 
%            they are in uO. But then xO=yO, which implies that there 
%            exists some z in O such that x*z=y. If the condition holds 
%            that {for all x, for all y, there exists a z such that 
%            if x and y are both not in the subgroup O, then z is in O and 
%            x*z=y}, then xO=yO for all x,y not in O, which implies that 
%            there are at most two cosets; and there must be at least two, 
%            namely O and xO, since x is not in O. Therefore O must 
%            be of index two.
%          : element_in_O2(A,B) is A^-1.B. The axioms with element_in_O2 
%            force index 2.
% Bugfixes : v1.0.1 - Duplicate axioms multiply_inverse_left and 
%            multiply_inverse_right removed.
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include the axioms for group theory in equality form 
include('Axioms/GRP004-0.ax').
%----Include the subgroup axioms in equality formulation 
include('Axioms/GRP004-1.ax').
%--------------------------------------------------------------------------
%----The next two clauses are previously established lemmas 
input_clause(inverse_inverse,axiom,
    [++equal(inverse(inverse(X)),X)]).

input_clause(inverse_of_identity,axiom,
    [++equal(inverse(identity),identity)]).

%----This axiom is dependent 
input_clause(identity_in_O2,axiom,
    [++subgroup_member(identity)]).

%----Definition of a subgroup of index 2 
input_clause(an_element_in_O2,axiom,
    [++subgroup_member(X),
     ++subgroup_member(Y),
     ++subgroup_member(element_in_O2(X,Y))]).

input_clause(property_of_O2,axiom,
    [++subgroup_member(X),
     ++subgroup_member(Y),
     ++equal(multiply(X,element_in_O2(X,Y)),Y)]).

input_clause(element_in_O2_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(element_in_O2(A,C),element_in_O2(B,C))]).

input_clause(element_in_O2_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(element_in_O2(F,D),element_in_O2(F,E))]).

%----Denial of theorem 
input_clause(b_in_O2,hypothesis,
    [++subgroup_member(b)]).

input_clause(b_times_a_inverse_is_c,hypothesis,
    [++equal(multiply(b,inverse(a)),c)]).

input_clause(a_times_c_is_d,hypothesis,
    [++equal(multiply(a,c),d)]).

input_clause(prove_d_in_O2,hypothesis,
    [--subgroup_member(d)]).
%--------------------------------------------------------------------------
