%--------------------------------------------------------------------------
% File     : GRP039=SubGI2Norm-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : Subgroups of index 2 are normal
% Version  : [Wos, 1965] axioms : Augmented.
% English  : If O is a subgroup of G and there are exactly 2 cosets 
%            in G/O, then O is normal [that is, for all x in G and 
%            y in O, x*y*inverse(x) is back in O].

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : wos19 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   32 (   2 non-Horn)(  12 unit)
%            Number of literals          :   68 (  24 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   5 constant)
%            Number of variables         :   73 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : Used to define a subgroup of index two is a theorem which 
%            says that {for all x, for all y, there exists a z such that 
%            if x and y are both not in the subgroup O, then z is in O and 
%            x*z=y} if & only if {O has index 2 in G}. This z is named 
%            by the skolem function i(x,y). Explanation: If O is of index 
%            two in G, then there are exactly two cosets, namely O and 
%            uO for some u not in O. If both of x and y are not in O, then 
%            they are in uO. But then xO=yO, which implies that there 
%            exists some z in O such that x*z=y. If the condition holds 
%            that {for all x, for all y, there exists a z such that 
%            if x and y are both not in the subgroup O, then z is in O and 
%            x*z=y}, then xO=yO for all x,y not in O, which implies that 
%            there are at most two cosets; and there must be at least two, 
%            namely O and xO, since x is not in O. Therefore O must 
%            be of index two.
%          : element_in_O2(A,B) is A^-1.B. The axioms with element_in_O2 
%            force index 2.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
%----The next five clauses are dependent lemmas 
input_clause(product_right_cancellation,axiom,
    [--product(A,B,C),
     --product(A,D,C),
     ++equal(D,B)]).

input_clause(product_left_cancellation,axiom,
    [--product(A,B,C),
     --product(D,B,C),
     ++equal(D,A)]).

input_clause(inverse_is_self_cancelling,axiom,
    [++equal(inverse(inverse(A)),A)]).

input_clause(identity_is_in_subgroup,axiom,
    [++subgroup_member(identity)]).

input_clause(subgroup_member_inverse_are_in_subgroup,axiom,
    [--subgroup_member(A),
     ++subgroup_member(inverse(A))]).

%----Definition of subgroup of index 2 
input_clause(an_element_in_O2,axiom,
    [++subgroup_member(element_in_O2(A,B)),
     ++subgroup_member(B),
     ++subgroup_member(A)]).

input_clause(property_of_O2,axiom,
    [++product(A,element_in_O2(A,B),B),
     ++subgroup_member(B),
     ++subgroup_member(A)]).

%----Extra substitution axiom 
input_clause(element_in_O2_substitution1,axiom,
    [--equal(A,B),
     ++equal(element_in_O2(C,A),element_in_O2(C,B))]).

input_clause(element_in_O2_substitution2,axiom,
    [--equal(A,B),
     ++equal(element_in_O2(A,C),element_in_O2(B,C))]).

%----Denial of theorem 
input_clause(b_is_in_subgroup,hypothesis,
    [++subgroup_member(b)]).

input_clause(b_times_a_inverse_is_c,hypothesis,
    [++product(b,inverse(a),c)]).

input_clause(a_times_c_is_d,hypothesis,
    [++product(a,c,d)]).

input_clause(prove_d_is_in_subgroup,theorem,
    [--subgroup_member(d)]).
%--------------------------------------------------------------------------
