%--------------------------------------------------------------------------
% File     : GRP038=SubGGrpEl-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups, if a and b are members, then a.b^-1 is a member
% Version  : [Wos, 1965] axioms : Augmented.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 18 [Wos, 1965]
%          : wos18 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   25 (   0 non-Horn)(  11 unit)
%            Number of literals          :   51 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   54 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This is trivial - its an axiom.
%          : Two extra lemmas are supplied.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
%----The next two clauses are dependent lemmas 
input_clause(closure_of_inverse,axiom,
    [--subgroup_member(A),
     ++subgroup_member(inverse(A))]).

input_clause(identity_is_in_subgroup,axiom,
    [++subgroup_member(identity)]).

input_clause(a_is_in_subgroup,hypothesis,
    [++subgroup_member(a)]).

input_clause(b_is_in_subgroup,hypothesis,
    [++subgroup_member(b)]).

input_clause(a_times_inverse_b_is_c,hypothesis,
    [++product(a,inverse(b),c)]).

input_clause(prove_c_is_in_subgroup,theorem,
    [--subgroup_member(c)]).
%--------------------------------------------------------------------------
