%--------------------------------------------------------------------------
% File     : GRP036=SubGIdUnq-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups, the identity element is unique
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 16 [Wos, 1965]
%          : wos16 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   27 (   0 non-Horn)(   8 unit)
%            Number of literals          :   58 (  20 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   60 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
input_clause(another_left_identity,hypothesis,
    [--subgroup_member(A),
     ++product(another_identity,A,A)]).

input_clause(another_right_identity,hypothesis,
    [--subgroup_member(A),
     ++product(A,another_identity,A)]).

input_clause(another_right_inverse,hypothesis,
    [--subgroup_member(A),
     ++product(A,another_inverse(A),another_identity)]).

input_clause(another_left_inverse,hypothesis,
    [--subgroup_member(A),
     ++product(another_inverse(A),A,another_identity)]).

input_clause(another_inverse_in_subgroup,hypothesis,
    [--subgroup_member(A),
     ++subgroup_member(another_inverse(A))]).

input_clause(another_inverse_substitution,hypothesis,
    [--equal(A,B),
     ++equal(another_inverse(A),another_inverse(B))]).

input_clause(another_identity_in_subgroup,hypothesis,
    [++subgroup_member(another_identity)]).

input_clause(prove_identity_equals_another_identity,theorem,
    [--equal(identity,another_identity)]).
%--------------------------------------------------------------------------
