%--------------------------------------------------------------------------
% File     : GRP034=SubGInvClsd-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups, inverse is closed
% Version  : [Lawrence & Starkey, 1974] axioms : Incomplete.
% English  : 

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls26 [Lawrence & Starkey, 1974]
%          : ls26 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   6 unit)
%            Number of literals          :   18 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   20 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(closure,axiom,
    [++product(X,Y,multiply(X,Y))]).

input_clause(left_identity,axiom,
    [++product(identity,X,X)]).

input_clause(right_identity,axiom,
    [++product(X,identity,X)]).

input_clause(right_inverse,axiom,
    [++product(X,inverse(X),identity)]).

input_clause(associativity1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(closure_of_subgroup,axiom,
    [--subgroup_member(A),
     --subgroup_member(B),
     --product(B,inverse(A),C),
     ++subgroup_member(C)]).

input_clause(a_is_in_subgroup,hypothesis,
    [++subgroup_member(a)]).

input_clause(prove_inverse_is_in_subgroup,theorem,
    [--subgroup_member(inverse(a))]).
%--------------------------------------------------------------------------
