%--------------------------------------------------------------------------
% File     : GRP034=SubGInvClsd-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups, inverse is closed
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 14 [Wos, 1965]
%          : wos14 [Wilson & Minker, 1976]
%          : wos_nie [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   8 unit)
%            Number of literals          :   46 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   53 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : Proves one of the [McCharen, et al., 1976] axioms.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
input_clause(a_is_in_subgroup,hypothesis,
    [++subgroup_member(a)]).

input_clause(prove_a_inverse_is_in_subgroup,theorem,
    [--subgroup_member(inverse(a))]).
%--------------------------------------------------------------------------
