%--------------------------------------------------------------------------
% File     : GRP033=SubGGrpIdEx-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups, the identity is the group identity
% Version  : [Wos, 1965] axioms : Reduced > Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 13 [Wos, 1965]
%          : wos13 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   22 (   0 non-Horn)(   7 unit)
%            Number of literals          :   50 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   2 constant)
%            Number of variables         :   55 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : Omits j substitutivity.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
%----j(A) is an element for which A is identity. In a subgroup this can 
%----be any element.

%----This subsitution axioms really should be in, but Wos omits it 
% input_clause(j_substitutivity1,axiom,
%     [--equal(A,B),
%      ++equal(j(A),j(B))]).

input_clause(a_is_in_subgroup,hypothesis,
    [++subgroup_member(a)]).

input_clause(subgr2_clause1,hypothesis,
    [--subgroup_member(A),
     ++subgroup_member(j(A))]).

input_clause(prove_subgr2,theorem,
    [--product(j(A),A,j(A)),
     --product(A,j(A),j(A)),
     --subgroup_member(A)]).
%--------------------------------------------------------------------------
