%--------------------------------------------------------------------------
% File     : GRP032=SubGIdEx-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Subgroups)
% Problem  : In subgroups, there is an identity
% Version  : [Wos, 1965] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 12 [Wos, 1965]
%          : wos12 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   8 unit)
%            Number of literals          :   46 (  17 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   53 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%----Include sub-group theory axioms 
include('Axioms/GRP003-2.ax').
include('Axioms/GRP003-2.eq').
%--------------------------------------------------------------------------
input_clause(a_is_in_subgroup,hypothesis,
    [++subgroup_member(a)]).

input_clause(prove_identity_is_in_subgroup,theorem,
    [--subgroup_member(identity)]).
%--------------------------------------------------------------------------
