%--------------------------------------------------------------------------
% File     : GRP031=SemiGRInvEx-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left inverse and id => right inverse exists
% Version  : [McCharen, et al., 1976] axioms : Reduced > Incomplete.
% English  : If there are right inverses and right identity, then every 
%            element has a left inverse.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls23 [Lawrence & Starkey, 1974]
%          : ls23 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   4 unit)
%            Number of literals          :   12 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   17 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This can also be viewed as a group theory problem, showing 
%            that the left inverse axiom is dependant on the rest of the 
%            axiom set; i.e., if there is a right inverse then there 
%            is a left inverse.
%--------------------------------------------------------------------------
%----Include semi-group axioms 
include('Axioms/GRP002-0.ax').
%--------------------------------------------------------------------------
input_clause(right_inverse,hypothesis,
    [++product(A,inverse(A),identity)]).

input_clause(right_identity,hypothesis,
    [++product(A,identity,A)]).

input_clause(prove_a_has_a_left_inverse,theorem,
    [--product(A,a,identity)]).
%--------------------------------------------------------------------------
