%--------------------------------------------------------------------------
% File     : GRP031=SemiGRInvEx-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left inverse and id => right inverse exists
% Version  : [McCharen, et al., 1976] axioms.
% English  : If there are left inverses and left identity, then every 
%            element has a right inverse.

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 5 [Wos, 1965]
%          : wos5 [Wilson & Minker, 1976]
%          : G4 [McCharen, et al., 1976]
%          : invers2.ver1.t [ANL]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   5 unit)
%            Number of literals          :   36 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   47 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This can also be viewed as a group theory problem, showing 
%            that the right inverse axiom is dependant on the rest of the 
%            axiom set; i.e., if there is a left inverse then there 
%            is a right inverse.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include semi-group axioms 
include('Axioms/GRP002-0.ax').
%----Include semi-group equality axioms 
include('Axioms/GRP002-0.eq').
%--------------------------------------------------------------------------
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(left_identity,hypothesis,
    [++product(identity,A,A)]).

input_clause(left_inverse,hypothesis,
    [++product(inverse(A),A,identity)]).

input_clause(prove_a_has_an_inverse,theorem,
    [--product(a,A,identity)]).
%--------------------------------------------------------------------------
