%--------------------------------------------------------------------------
% File     : GRP030=SemiGLIdEqRId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left id and inverse => left id=right id
% Version  : [McCharen, et al., 1976] axioms.
% English  : If there are a left identity and left inverse, then the left 
%            identity is also a right identity.

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 2 [Wos, 1965]
%          : wos2 [Wilson & Minker, 1976]
%          : G3 [McCharen, et al., 1976]
%          : ident1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   5 unit)
%            Number of literals          :   36 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   46 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This can also be viewed as a group theory problem, showing 
%            that the right identity axiom is dependant on the rest of the 
%            axiom set; i.e., if e is the left identity, then e is also 
%            a right identity.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include semi-group axioms 
include('Axioms/GRP002-0.ax').
%----Include semi-group equality axioms 
include('Axioms/GRP002-0.eq').
%--------------------------------------------------------------------------
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(left_identity,hypothesis,
    [++product(identity,A,A)]).

input_clause(left_inverse,hypothesis,
    [++product(inverse(A),A,identity)]).

input_clause(prove_identity_is_a_right_identity,theorem,
    [--product(a,identity,a)]).
%--------------------------------------------------------------------------
