%--------------------------------------------------------------------------
% File     : GRP029=SemiGRIdEx2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left id and inverse => right id exists
% Version  : [McCharen, et al., 1976] axioms : Incomplete.
% English  : If there are a left identity and left inverse, then there 
%            is a right identity element.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [SPRFN]
% Names    : G5 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   5 unit)
%            Number of literals          :   36 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   1 constant)
%            Number of variables         :   47 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : This may also be viewed as a group theory problem, to prove 
%            that the right identity axiom is dependant on the rest of the 
%            axiom set; i.e., each element has a right identity. Note that 
%            this is a corollary to proving that the right identity axiom 
%            is dependant on the rest of the axiom set, but also that the 
%            proof is different due to the introduction of a skolem 
%            function for the right identity of each element of the group.
%          : The inverse_substitution substitution axioms are missing.
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include semi-group axioms 
include('Axioms/GRP002-0.ax').
%----Include semi-group equality axioms 
include('Axioms/GRP002-0.eq').
%--------------------------------------------------------------------------
input_clause(inverse_substitution,axiom,
    [--equal(X,Y),
     ++equal(inverse(X),inverse(Y))]).

input_clause(left_identity,axiom,
    [++product(identity,A,A)]).

input_clause(left_inverse,axiom,
    [++product(inverse(A),A,identity)]).

input_clause(prove_there_is_a_right_identity,theorem,
    [--product(not_right_identity(A),A,not_right_identity(A))]).
%--------------------------------------------------------------------------
