%--------------------------------------------------------------------------
% File     : GRP028=SemiGRIdEx1-3 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left and right solutions => right id exists
% Version  : [McCharen, et al., 1976] axioms : Reduced > Incomplete.
% English  : If there are left and right solutions, then there is a right 
%            identity element.

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [Luckham, 1968]
% Names    : Example 1 [Luckham, 1968]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   4 unit)
%            Number of literals          :   12 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   0 constant)
%            Number of variables         :   19 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : [Luckham, 1968] uses less axioms than [McCharen, et al., 
%            1976]
%--------------------------------------------------------------------------
%----Include Semigroup axioms 
% include('Axioms/GRP002-0.ax').
%----Include Substitution axioms for semigroup axioms 
% include('Axioms/GRP002-0.eq').
%--------------------------------------------------------------------------
%----This axiom is called closure or totality in some axiomatisations 
input_clause(total_function1,axiom,
    [++product(X,Y,multiply(X,Y))]).

%----This axiom is called well_definedness in some axiomatisations 
%input_clause(total_function2,axiom,
%    [--product(X,Y,Z),
%     --product(X,Y,W),
%     ++equal(Z,W)]).

input_clause(associativity1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(left_soln,hypothesis,
    [++product(left_solution(X,Y),X,Y)]).

input_clause(right_soln,hypothesis,
    [++product(X,right_solution(X,Y),Y)]).

%----There is an element for which no X is identity 
input_clause(prove_there_is_a_right_identity,theorem,
    [--product(not_identity(X),X,not_identity(X))]).
%--------------------------------------------------------------------------
