%--------------------------------------------------------------------------
% File     : GRP028=SemiGRIdEx1-2 : TPTP v1.1.1. Bugfixed v1.1.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left and right solutions => right id exists
% Version  : [McCharen, et al., 1976] axioms.
% English  : If there are left and right solutions, then there is a right 
%            identity element.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(   5 unit)
%            Number of literals          :   44 (  24 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   0 constant)
%            Number of variables         :   61 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Semigroup axioms 
include('Axioms/GRP002-0.ax').
%----Include Substitution axioms for semigroup axioms 
include('Axioms/GRP002-0.eq').
%--------------------------------------------------------------------------
input_clause(left_solution_substitution1,axiom,
    [--equal(D,E),
     ++equal(left_solution(D,F),left_solution(E,F))]).

input_clause(left_solution_substitution2,axiom,
    [--equal(G,H),
     ++equal(left_solution(I,G),left_solution(I,H))]).

input_clause(not_identity_substitution1,axiom,
    [--equal(P,Q),
     ++equal(not_identity(P),not_identity(Q))]).

input_clause(right_solution_substitution1,axiom,
    [--equal(R,S),
     ++equal(right_solution(R,T),right_solution(S,T))]).

input_clause(right_solution_substitution2,axiom,
    [--equal(U,V),
     ++equal(right_solution(W,U),right_solution(W,V))]).

input_clause(left_soln,hypothesis,
    [++product(left_solution(X,Y),X,Y)]).

input_clause(right_soln,hypothesis,
    [++product(X,right_solution(X,Y),Y)]).

%----There is an element for which no X is identity 
input_clause(prove_there_is_a_right_identity,theorem,
    [--product(not_identity(X),X,not_identity(X))]).
%--------------------------------------------------------------------------
