%--------------------------------------------------------------------------
% File     : GRP028=SemiGRIdEx1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Semigroups)
% Problem  : In semigroups, left and right solutions => right id exists
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : If there are left and right solutions, then there is a right 
%            identity element.

% Refs     : Slagle J.R. (1967), Automatic Theorem Proving With Renamable 
%            Semantic Resolution, Journal of the ACM 14(4), 687-697.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [Chang, 1970]
% Names    : ALGEBRA THEOREM [Slagle, 1967]
%          : Chang-Lee-1 [Chang, 1970]
%          : GROUP1 [Wilson & Minker, 1976]
%          : EX1 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    7 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   0 constant)
%            Number of variables         :   11 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(associativity,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(left_soln,hypothesis,
    [++product(left_solution(X,Y),X,Y)]).

input_clause(right_soln,hypothesis,
    [++product(X,right_solution(X,Y),Y)]).

%----There is an element for which no X is identity 
input_clause(prove_there_is_a_right_identity,theorem,
    [--product(not_identity(X),X,not_identity(X))]).
%--------------------------------------------------------------------------
