%--------------------------------------------------------------------------
% File     : GRP027=O5Cyclic-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Named groups)
% Problem  : All groups of order 5 are cyclic
% Version  : [McCharen, et al., 1976] axioms : Incomplete.
% English  : There exists an element in G that generates all other 
%            elements by taking powers of that element.

% Refs     : 
% Source   : [ANL]
% Names    : cyclic.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   39 (   1 non-Horn)(  18 unit)
%            Number of literals          :   78 (  33 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (   6 constant)
%            Number of variables         :   95 (   1 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    5

% Comments : This theorem is proven via the fact that any element raised 
%            to the power of the group gives the identity element back, 
%            and that therefore only powers up to 5 in this case need 
%            be investigated.
%          : This version omits 2 substitution axioms
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include the axioms for named groups 
include('Axioms/GRP006-0.ax').
%----Include the equality axioms for named groups 
include('Axioms/GRP006-0.eq').
%--------------------------------------------------------------------------
%----Elements of the group of order 5 
input_clause(a_in_group,hypothesis,
    [++group_member(a,g)]).

input_clause(b_in_group,hypothesis,
    [++group_member(b,g)]).

input_clause(c_in_group,hypothesis,
    [++group_member(c,g)]).

input_clause(d_in_group,hypothesis,
    [++group_member(d,g)]).

input_clause(i_in_group,hypothesis,
    [++group_member(i,g)]).

input_clause(i_is_identity,hypothesis,
    [++equal(identity_for(g),i)]).

input_clause(all_of_group,hypothesis,
    [--group_member(X,g),
     ++equal(X,a),
     ++equal(X,b),
     ++equal(X,c),
     ++equal(X,d),
     ++equal(X,i)]).

input_clause(multiplication_to_identity,hypothesis,
    [++equal(multiply(g,X,multiply(g,X,multiply(g,X,
multiply(g,X,X)))),i)]).

input_clause(all_multiply_to_identity,hypothesis,
    [--equal(not_power_of(g,X),X)]).

%----Denial of theorem : For all X in g, there exists a Y such that X<>Y, 
%----and X^2<>Y, and X^3<>Y, and X^4<>Y, and X^5<>Y.
input_clause(x2_is_not_power,theorem,
    [--product(g,X,X,not_power_of(g,X))]).

input_clause(x3_is_not_power,theorem,
    [--product(g,X,multiply(g,X,X),not_power_of(g,X))]).

input_clause(x4_is_not_power,theorem,
    [--product(g,X,multiply(g,X,multiply(g,X,X)),not_power_of(g,X))]).

input_clause(x5_is_not_power,theorem,
    [--product(g,X,multiply(g,X,multiply(g,X,multiply(g,X,X))),
not_power_of(g,X))]).
%--------------------------------------------------------------------------
