%--------------------------------------------------------------------------
% File     : GRP026=O3Isom-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Named groups)
% Problem  : All groups of order 3 are isomorphic
% Version  : [McCharen, et al., 1976] axioms.
% English  : If G1 and G2 each have exactly three elements, then there 
%            exists an isomorphism [a one-to-one and onto homomorphism] 
%            between them.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : G9 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   82 (   2 non-Horn)(  47 unit)
%            Number of literals          :  145 (  88 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   20 (  11 constant)
%            Number of variables         :  124 (   1 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : In order to prove the theorem, we specify one element of each 
%            group as the identity element and take as a previously-proven 
%            lemma (obvious) that maps from G1 -> G2 which are not 
%            one-to-one or which are not onto need not be considered for 
%            isomorphisms between the groups. Thus we consider only the 
%            six one-to-one and onto maps between the groups, and show 
%            that assuming none of them are homomorphisms gives 
%            a contradiction.
%          : This is the more general formulation of the problem. This 
%            version does not differentiate between group members 
%            as is done in the same problem for groups of order 2.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include the axioms for named groups 
include('Axioms/GRP006-0.ax').
%----Include the equality axioms for named groups 
include('Axioms/GRP006-0.eq').
%--------------------------------------------------------------------------
%----Definition of the two groups of order 3 
input_clause(two_groups,hypothesis,
    [--equal(g1,g2)]).

input_clause(a_member_of_group1,hypothesis,
    [++group_member(a,g1)]).

input_clause(b_member_of_group1,hypothesis,
    [++group_member(b,g1)]).

input_clause(c_member_of_group1,hypothesis,
    [++group_member(c,g1)]).

input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

input_clause(c_not_a,hypothesis,
    [--equal(c,a)]).

input_clause(b_not_c,hypothesis,
    [--equal(b,c)]).

input_clause(f_member_of_group2,hypothesis,
    [++group_member(f,g2)]).

input_clause(g_member_of_group2,hypothesis,
    [++group_member(g,g2)]).

input_clause(h_member_of_group2,hypothesis,
    [++group_member(h,g2)]).

input_clause(f_not_g,hypothesis,
    [--equal(f,g)]).

input_clause(h_not_f,hypothesis,
    [--equal(h,f)]).

input_clause(g_not_h,hypothesis,
    [--equal(g,h)]).

input_clause(all_of_group1,hypothesis,
    [--group_member(X,g1),
     ++equal(X,a),
     ++equal(X,b),
     ++equal(X,c)]).

input_clause(all_of_group2,hypothesis,
    [--group_member(X,g2),
     ++equal(X,f),
     ++equal(X,g),
     ++equal(X,h)]).

%----a is the identity of group1, f of group2 
input_clause(a_identity_of_group1,hypothesis,
    [++equal(identity_for(g1),a)]).

input_clause(f_identity_of_group2,hypothesis,
    [++equal(identity_for(g2),f)]).

input_clause(a_left_identity,hypothesis,
    [++product(g1,a,X,X)]).

input_clause(a_right_identity,hypothesis,
    [++product(g1,X,a,X)]).

input_clause(f_left_identity,hypothesis,
    [++product(g2,f,X,X)]).

input_clause(f_right_identity,hypothesis,
    [++product(g2,X,f,X)]).

%----Definition of the six possible isomorphisms 
input_clause(a_maps1_to_f,hypothesis,
    [++equal(isomorphism1(a),f)]).

input_clause(b_maps1_to_g,hypothesis,
    [++equal(isomorphism1(b),g)]).

input_clause(c_maps1_to_h,hypothesis,
    [++equal(isomorphism1(c),h)]).

input_clause(a_maps2_to_f,hypothesis,
    [++equal(isomorphism2(a),f)]).

input_clause(b_maps2_to_h,hypothesis,
    [++equal(isomorphism2(b),h)]).

input_clause(c_maps2_to_g,hypothesis,
    [++equal(isomorphism2(c),g)]).

input_clause(a_maps3_to_g,hypothesis,
    [++equal(isomorphism3(a),g)]).

input_clause(b_maps3_to_f,hypothesis,
    [++equal(isomorphism3(b),f)]).

input_clause(c_maps3_to_h,hypothesis,
    [++equal(isomorphism3(c),h)]).

input_clause(a_maps4_to_g,hypothesis,
    [++equal(isomorphism4(a),g)]).

input_clause(b_maps4_to_h,hypothesis,
    [++equal(isomorphism4(b),h)]).

input_clause(c_maps4_to_c,hypothesis,
    [++equal(isomorphism4(c),f)]).

input_clause(a_maps5_to_h,hypothesis,
    [++equal(isomorphism5(a),h)]).

input_clause(b_maps5_to_g,hypothesis,
    [++equal(isomorphism5(b),g)]).

input_clause(c_maps5_to_f,hypothesis,
    [++equal(isomorphism5(c),f)]).

input_clause(a_maps6_to_h,hypothesis,
    [++equal(isomorphism6(a),h)]).

input_clause(b_maps6_to_f,hypothesis,
    [++equal(isomorphism6(b),f)]).

input_clause(c_maps6_to_g,hypothesis,
    [++equal(isomorphism6(c),g)]).

%----Equality substitution for the isomorphisms 
input_clause(isomorphism1_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism1(X),isomorphism1(Y))]).

input_clause(isomorphism2_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism2(X),isomorphism2(Y))]).

input_clause(isomorphism3_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism3(X),isomorphism3(Y))]).

input_clause(isomorphism4_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism4(X),isomorphism4(Y))]).

input_clause(isomorphism5_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism5(X),isomorphism5(Y))]).

input_clause(isomorphism6_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism6(X),isomorphism6(Y))]).

input_clause(isomorphism1_substitution2,axiom,
    [--equal(X,isomorphism1(Z)),
     --equal(Y,isomorphism1(Z)),
     ++equal(X,Y)]).

input_clause(isomorphism2_substitution2,axiom,
    [--equal(X,isomorphism2(Z)),
     --equal(Y,isomorphism2(Z)),
     ++equal(X,Y)]).

input_clause(isomorphism3_substitution2,axiom,
    [--equal(X,isomorphism3(Z)),
     --equal(Y,isomorphism3(Z)),
     ++equal(X,Y)]).

input_clause(isomorphism4_substitution2,axiom,
    [--equal(X,isomorphism4(Z)),
     --equal(Y,isomorphism4(Z)),
     ++equal(X,Y)]).

input_clause(isomorphism5_substitution2,axiom,
    [--equal(X,isomorphism5(Z)),
     --equal(Y,isomorphism5(Z)),
     ++equal(X,Y)]).

input_clause(isomorphism6_substitution2,axiom,
    [--equal(X,isomorphism6(Z)),
     --equal(Y,isomorphism6(Z)),
     ++equal(X,Y)]).

%----Denial that one of the two isomorphisms is one 
input_clause(d1_member_of_group1,hypothesis,
    [++group_member(d1,g1)]).

input_clause(d2_member_of_group1,hypothesis,
    [++group_member(d2,g1)]).

input_clause(d3_member_of_group1,hypothesis,
    [++group_member(d3,g1)]).

input_clause(d1_times_d2_is_d3,hypothesis,
    [++product(g1,d1,d2,d3)]).

input_clause(prove_one_product_holds_in_group2,theorem,
    [--product(g2,isomorphism1(d1),isomorphism1(d2),isomorphism1(d3)),
     --product(g2,isomorphism2(d1),isomorphism2(d2),isomorphism2(d3)),
     --product(g2,isomorphism3(d1),isomorphism3(d2),isomorphism3(d3)),
     --product(g2,isomorphism4(d1),isomorphism4(d2),isomorphism4(d3)),
     --product(g2,isomorphism5(d1),isomorphism5(d2),isomorphism5(d3)),
     --product(g2,isomorphism6(d1),isomorphism6(d2),isomorphism6(d3))]).
%--------------------------------------------------------------------------
