%--------------------------------------------------------------------------
% File     : GRP026=O3Isom-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Named groups)
% Problem  : All groups of order 3 are isomorphic
% Version  : [McCharen, et al., 1976] axioms.
%            Theorem formulation : Incomplete.
% English  : If G1 and G2 each have exactly three elements, then there 
%            exists an isomorphism [a one-to-one and onto homomorphism] 
%            between them.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : G9 [McCharen, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   61 (   2 non-Horn)(  38 unit)
%            Number of literals          :  102 (  36 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   15 (  11 constant)
%            Number of variables         :   92 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : In order to prove the theorem, the group tables and 
%            a particular homomorphism are specified, and the 
%            contradiction comes from the fact that this is the actual 
%            isomorphism. Not only is this formulation cheating, but also 
%            it does not prove the theorem in full generality.
%          : A substitution axiom, missing in the ANL presentation, 
%            is included.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include the axioms for named groups 
include('Axioms/GRP006-0.ax').
%----Include the equality axioms for named groups 
include('Axioms/GRP006-0.eq').
%--------------------------------------------------------------------------
%----Definition of the two groups 
input_clause(a_in_group1,hypothesis,
    [++group_member(a,g1)]).

input_clause(b_in_group1,hypothesis,
    [++group_member(b,g1)]).

input_clause(c_in_group1,hypothesis,
    [++group_member(c,g1)]).

input_clause(f_in_group2,hypothesis,
    [++group_member(f,g2)]).

input_clause(g_in_group2,hypothesis,
    [++group_member(g,g2)]).

input_clause(h_in_group2,hypothesis,
    [++group_member(h,g2)]).

input_clause(all_of_group1,hypothesis,
    [--group_member(X,g1),
     ++equal(X,a),
     ++equal(X,b),
     ++equal(X,c)]).

input_clause(all_of_group2,hypothesis,
    [--group_member(X,g2),
     ++equal(X,f),
     ++equal(X,g),
     ++equal(X,h)]).

input_clause(a_times_a_is_a,hypothesis,
    [++product(g1,a,a,a)]).

input_clause(a_times_b_is_b,hypothesis,
    [++product(g1,a,b,b)]).

input_clause(b_times_a_is_b,hypothesis,
    [++product(g1,b,a,b)]).

input_clause(a_times_c_is_c,hypothesis,
    [++product(g1,a,c,c)]).

input_clause(c_times_a_is_c,hypothesis,
    [++product(g1,c,a,c)]).

input_clause(b_times_b_is_c,hypothesis,
    [++product(g1,b,b,c)]).

input_clause(b_times_c_is_a,hypothesis,
    [++product(g1,b,c,a)]).

input_clause(c_times_b_is_a,hypothesis,
    [++product(g1,c,b,a)]).

input_clause(c_times_c_is_b,hypothesis,
    [++product(g1,c,c,b)]).

input_clause(f_times_f_is_f,hypothesis,
    [++product(g2,f,f,f)]).

input_clause(f_times_g_is_g,hypothesis,
    [++product(g2,f,g,g)]).

input_clause(g_times_f_is_g,hypothesis,
    [++product(g2,g,f,g)]).

input_clause(f_times_h_is_h,hypothesis,
    [++product(g2,f,h,h)]).

input_clause(h_times_f_is_h,hypothesis,
    [++product(g2,h,f,h)]).

input_clause(g_times_g_is_h,hypothesis,
    [++product(g2,g,g,h)]).

input_clause(g_times_h_is_f,hypothesis,
    [++product(g2,g,h,f)]).

input_clause(h_times_g_is_f,hypothesis,
    [++product(g2,h,g,f)]).

input_clause(h_times_h_is_g,hypothesis,
    [++product(g2,h,h,g)]).

%----Definition of an isomorphism 
input_clause(a_maps_to_f,hypothesis,
    [++equal(an_isomorphism(a),f)]).

input_clause(b_maps_to_g,hypothesis,
    [++equal(an_isomorphism(b),g)]).

input_clause(c_maps_to_h,hypothesis,
    [++equal(an_isomorphism(c),h)]).

%----Substitution axiom for an_isomorphism 
input_clause(an_isomorphism_substitution1,axiom,
    [--equal(X,Y),
     ++equal(an_isomorphism(X),an_isomorphism(Y))]).

%----Denial that the isomorphism is one 
input_clause(d1_in_group1,hypothesis,
    [++group_member(d1,g1)]).

input_clause(d2_in_group1,hypothesis,
    [++group_member(d2,g1)]).

input_clause(d3_in_group1,hypothesis,
    [++group_member(d3,g1)]).

input_clause(d1_times_d2_is_d3,hypothesis,
    [++product(g1,d1,d2,d3)]).

input_clause(prove_product_holds_in_group2,theorem,
    [--product(g1,an_isomorphism(d1),an_isomorphism(d2),
an_isomorphism(d3))]).
%--------------------------------------------------------------------------
