%--------------------------------------------------------------------------
% File     : GRP025=O2Isom-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Named groups)
% Problem  : All groups of order 2 are isomorphic
% Version  : [McCharen, et al., 1976] axioms : Augmented.
% English  : If G1 has exactly two elements and G2 has exactly two 
%            elements, then there exists an isomorphism [a one-to-one and 
%            onto homomorphism] between them.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : G8 [McCharen, et al., 1976]
%          : order2.ver4.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   60 (   2 non-Horn)(  31 unit)
%            Number of literals          :  109 (  54 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   14 (   9 constant)
%            Number of variables         :  114 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : In order to prove the theorem, we specify one element of each 
%            group as the identity element and take as a previously-proven 
%            lemma (obvious) that maps from G1 -> G2 which are not 
%            one-to-one or which are not onto need not be considered for 
%            isomorphisms between the groups. Thus we consider only the 
%            two one-to-one and onto maps between the groups, and show 
%            that assuming neither of them are homomorphisms gives 
%            a contradiction.
%          : This formulation is a more general one.
%          : Two extra axioms (left and right cancellation) are used, and 
%            an obvious lemma is assumed.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include the axioms for named groups 
include('Axioms/GRP006-0.ax').
%----Include the equality axioms for named groups 
include('Axioms/GRP006-0.eq').
%--------------------------------------------------------------------------
%----Extra axioms 
input_clause(left_cancellation,axiom,
    [--product(Xg,X,Z,Y),
     --product(Xg,X,W,Y),
     ++equal(W,Z)]).

input_clause(right_cancellation,axiom,
    [--product(Xg,Z,Y,X),
     --product(Xg,W,Y,X),
     ++equal(W,Z)]).

%----Definition of the two groups 
input_clause(two_groups,hypothesis,
    [--equal(g1,g2)]).

input_clause(a_member_of_group1,hypothesis,
    [++group_member(a,g1)]).

input_clause(b_member_of_group1,hypothesis,
    [++group_member(b,g1)]).

input_clause(c_member_of_group2,hypothesis,
    [++group_member(c,g2)]).

input_clause(d_member_of_group2,hypothesis,
    [++group_member(d,g2)]).

input_clause(a_not_b,hypothesis,
    [--equal(a,b)]).

input_clause(c_not_d,hypothesis,
    [--equal(c,d)]).

input_clause(a_not_c,hypothesis,
    [--equal(a,c)]).

input_clause(a_not_d,hypothesis,
    [--equal(a,d)]).

input_clause(b_not_c,hypothesis,
    [--equal(b,c)]).

input_clause(b_not_d,hypothesis,
    [--equal(b,d)]).

input_clause(a_and_b_only_members_of_group1,hypothesis,
    [--group_member(X,g1),
     ++equal(X,a),
     ++equal(X,b)]).

input_clause(c_and_d_only_members_of_group2,hypothesis,
    [--group_member(X,g2),
     ++equal(X,c),
     ++equal(X,d)]).

%----a is the identity of group1, c of group2 
input_clause(a_identity_of_group1,hypothesis,
    [++equal(identity_for(g1),a)]).

input_clause(c_identity_of_group2,hypothesis,
    [++equal(identity_for(g2),c)]).

input_clause(a_left_identity,hypothesis,
    [++product(g1,a,X,X)]).

input_clause(a_right_identity,hypothesis,
    [++product(g1,X,a,X)]).

input_clause(c_left_identity,hypothesis,
    [++product(g2,c,X,X)]).

input_clause(c_right_identity,hypothesis,
    [++product(g2,X,c,X)]).

%----Definition of the two possible isomorphisms 
input_clause(a_maps1_to_c,hypothesis,
    [++equal(isomorphism1(a),c)]).

input_clause(b_maps1_to_d,hypothesis,
    [++equal(isomorphism1(b),d)]).

input_clause(a_maps2_to_d,hypothesis,
    [++equal(isomorphism2(a),d)]).

input_clause(b_maps2_to_c,hypothesis,
    [++equal(isomorphism2(b),c)]).

%----Equality substitution for the isomorphisms 
input_clause(isomorphism1_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism1(X),isomorphism1(Y))]).

input_clause(isomorphism2_substitution1,axiom,
    [--equal(X,Y),
     ++equal(isomorphism2(X),isomorphism2(Y))]).

input_clause(isomorphism1_substitution2,axiom,
    [--equal(X,isomorphism1(Z)),
     --equal(Y,isomorphism1(Z)),
     ++equal(X,Y)]).

input_clause(isomorphism2_substitution2,axiom,
    [--equal(X,isomorphism2(Z)),
     --equal(Y,isomorphism2(Z)),
     ++equal(X,Y)]).

%----Denial that one of the two isomorphisms is one 
input_clause(d1_member_of_group1,hypothesis,
    [++group_member(d1,g1)]).

input_clause(d2_member_of_group1,hypothesis,
    [++group_member(d2,g1)]).

input_clause(d3_member_of_group1,hypothesis,
    [++group_member(d3,g1)]).

input_clause(d1_times_d2_is_d3,hypothesis,
    [++product(g1,d1,d2,d3)]).

input_clause(prove_one_product_holds_in_group2,theorem,
    [--product(g2,isomorphism1(d1),isomorphism1(d2),isomorphism1(d3)),
     --product(g2,isomorphism2(d1),isomorphism2(d2),isomorphism2(d3))]).
%--------------------------------------------------------------------------
