%--------------------------------------------------------------------------
% File     : GRP025=O2Isom-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory (Named groups)
% Problem  : All groups of order 2 are isomorphic
% Version  : [McCharen, et al., 1976] axioms : Incomplete.
%            Theorem formulation : Incomplete.
% English  : If G1 has exactly two elements and G2 has exactly two 
%            elements, then there exists an isomorphism [a one-to-one and 
%            onto homomorphism] between them.

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : G8 [McCharen, et al., 1976]
%          : order2.ver3.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   47 (   2 non-Horn)(  25 unit)
%            Number of literals          :   85 (  31 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   13 (   9 constant)
%            Number of variables         :   90 (   1 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : In order to prove the theorem, the group tables and 
%            a particular homomorphism are specified, and the 
%            contradiction comes from the fact that this is the actual 
%            isomorphism. Not only is this formulation cheating, but also 
%            it does not prove the theorem in full generality.
%          : Missing an_isomorphism subsitution axioms.
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include the axioms for named groups 
include('Axioms/GRP006-0.ax').
%----Include the equality axioms for named groups 
include('Axioms/GRP006-0.eq').
%--------------------------------------------------------------------------
%----Definition of the two groups 
input_clause(a_member_of_group1,hypothesis,
    [++group_member(a,g1)]).

input_clause(b_member_of_group1,hypothesis,
    [++group_member(b,g1)]).

input_clause(c_member_of_group2,hypothesis,
    [++group_member(c,g2)]).

input_clause(d_member_of_group2,hypothesis,
    [++group_member(d,g2)]).

input_clause(a_and_b_only_members_of_group1,hypothesis,
    [--group_member(X,g1),
     ++equal(X,a),
     ++equal(X,b)]).

input_clause(c_and_d_only_members_of_group2,hypothesis,
    [--group_member(X,g2),
     ++equal(X,c),
     ++equal(X,d)]).

input_clause(a_times_a_is_a,hypothesis,
    [++product(g1,a,a,a)]).

input_clause(a_times_b_is_b,hypothesis,
    [++product(g1,a,b,b)]).

input_clause(b_times_a_is_b,hypothesis,
    [++product(g1,b,a,b)]).

input_clause(b_times_b_is_a,hypothesis,
    [++product(g1,b,b,a)]).

input_clause(c_times_c_is_c,hypothesis,
    [++product(g2,c,c,c)]).

input_clause(c_times_d_is_d,hypothesis,
    [++product(g2,c,d,d)]).

input_clause(d_times_c_is_d,hypothesis,
    [++product(g2,d,c,d)]).

input_clause(d_times_d_is_c,hypothesis,
    [++product(g2,d,d,c)]).

%----Definition of the isomorphism 
input_clause(a_maps_to_c,hypothesis,
    [++equal(an_isomorphism(a),c)]).

input_clause(b_maps_to_d,hypothesis,
    [++equal(an_isomorphism(b),d)]).

%----Denial that the isomorphism is indeed one 
input_clause(d1_member_of_group1,hypothesis,
    [++group_member(d1,g1)]).

input_clause(d2_member_of_group1,hypothesis,
    [++group_member(d2,g1)]).

input_clause(d3_member_of_group1,hypothesis,
    [++group_member(d3,g1)]).

input_clause(d1_times_d2_is_d3,hypothesis,
    [++product(g1,d1,d2,d3)]).

input_clause(prove_product_holds_in_group2,theorem,
    [--product(g2,an_isomorphism(d1),an_isomorphism(d2),
an_isomorphism(d3))]).
%--------------------------------------------------------------------------
