%--------------------------------------------------------------------------
% File     : GRP024=CmtrAssc-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Associativity of commutator
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : The commutator operation is associative if and only if the 
%            commutator of any two elements lies in the center of the 
%            group, i.e. [[X,Y],Z]=[X,[Y,Z]] iff [U,V]*W=W*[U,V].

% Refs     : Kurosh A.G. (1956), The Theory of Groups, Volume 1, Chelsea, 
%            New York, NY, 99-100.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : McCune W.W and Lusk E. (1992), A Challenging Theorem of Levi, 
%            Association for Automated Reasoning Newsletter 21, 8-8.
% Source   : [McCune & Lusk, 1992]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   16 (   1 non-Horn)(   7 unit)
%            Number of literals          :   26 (  26 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   10 (   7 constant)
%            Number of variables         :   29 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : A textbook proof can be found in [Kurosh, 1956].
%          : Uses an explicit formulation of the commutator
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
%----Definition of the commutator 
input_clause(commutator,axiom,
    [++equal(commutator(X,Y),multiply(X,multiply(Y,multiply(inverse(X),
inverse(Y)))))]).

input_clause(commutator_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(commutator(A,C),commutator(B,C))]).

input_clause(commutator_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(commutator(F,D),commutator(F,E))]).

input_clause(associativity_or_center,theorem,
    [++equal(commutator(commutator(a,b),c),commutator(a,
commutator(b,c))),
     ++equal(multiply(commutator(e,f),g),multiply(g,commutator(e,f)))]).

input_clause(not_both_associativity_and_center,theorem,
    [--equal(commutator(commutator(a,b),c),commutator(a,
commutator(b,c))),
     --equal(multiply(commutator(e,f),g),multiply(g,commutator(e,f)))]).
%--------------------------------------------------------------------------
