%--------------------------------------------------------------------------
% File     : GRP023=InvOfId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : The inverse of the identity is the identity
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Overbeek R., McCharen J., and Wos L. (1976), Complexity and 
%            Related Enhancements for Automated Theorem-Proving Programs, 
%            Computer and Mathematics with Applications 2, 1-16.
% Source   : [McCharen, et al., 1976]
% Names    : Identity established [McCharen, et al., 1976]
%          : Lemma proved [Overbeek, et al., 1976]

% Status   : 
% Syntax   : Number of clauses           :   18 (   0 non-Horn)(   7 unit)
%            Number of literals          :   38 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    3 (   1 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_inverse_of_id_is_id,theorem,
    [--equal(inverse(identity),identity)]).
%--------------------------------------------------------------------------
