%--------------------------------------------------------------------------
% File     : GRP022=InvIvln-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Inverse is an involution
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : 

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Lusk E., and Overbeek R. (1985), Reasoning about Equality, 
%            Journal of Automated Reasoning 1(2), 209-228.
% Source   : [TPTP]
% Names    : Established lemma [McCharen, et al., 1976]
%          : Problem 2 [Lusk & Overbeek, 1985]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   7 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include equality group theory axioms 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_inverse_of_inverse_is_original,theorem,
    [--equal(inverse(inverse(a)),a)]).
%--------------------------------------------------------------------------
