%--------------------------------------------------------------------------
% File     : GRP017=InvUnq-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : The inverse of each element is unique
% Version  : [McCharen, et al., 1976] axioms.
% English  : i.e., if ab=ba=identity and ac=ca=identity then b=c

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : G2 [McCharen, et al., 1976]
%          : invers1.ver1.in [ANL]

% Status   : 
% Syntax   : Number of clauses           :   22 (   0 non-Horn)(  11 unit)
%            Number of literals          :   42 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_times_b_is_identity,hypothesis,
    [++product(a,b,identity)]).

input_clause(b_times_a_is_identity,hypothesis,
    [++product(b,a,identity)]).

input_clause(a_times_c_is_identity,hypothesis,
    [++product(a,c,identity)]).

input_clause(c_times_a_is_identity,hypothesis,
    [++product(c,a,identity)]).

input_clause(prove_b_equals_c,theorem,
    [--equal(b,c)]).
%--------------------------------------------------------------------------
