%--------------------------------------------------------------------------
% File     : GRP015=GroupEx-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : x,<<x x,X> x,X> is a group
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3) 87-327.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 224-225 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  326 (  27 non-Horn)(  14 unit)
%            Number of literals          :  778 ( 340 equality)
%            Number of predicate symbols :   19 (   0 propositional)
%            Number of function symbols  :   69 (   7 constant)
%            Number of variables         :  930 (  32 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%----Include the axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.ax').
%----Include the equality axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.eq').
%--------------------------------------------------------------------------
input_clause(a_little_set,hypothesis,
    [++little_set(a)]).

input_clause(prove_the_group,theorem,
    [--group(singleton_set(a),singleton_set(ordered_pair(
ordered_pair(a,a),a)))]).
%--------------------------------------------------------------------------
