%--------------------------------------------------------------------------
% File     : GRP014=ProdAssc-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Product is associative in this group theory
% Version  : [Overbeek, 1990] (equality) axioms : Incomplete.
% English  : The group theory specified by the axiom given implies the 
%            associativity of multiply.

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition Eq-4 [Overbeek, 1990]

% Status   : 
% Syntax   : Number of clauses           :    8 (   0 non-Horn)(   3 unit)
%            Number of literals          :   14 (  14 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   18 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    9

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(inverse_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(inverse(A),inverse(B))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(multiply(C,E),multiply(D,E))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(F,G),
     ++equal(multiply(H,F),multiply(H,G))]).

input_clause(group_axiom,axiom,
    [++equal(multiply(X,inverse(multiply(multiply(inverse(multiply(
inverse(Y),multiply(inverse(X),W))),Z),inverse(multiply(Y,Z))))),W)]).

input_clause(prove_associativity,theorem,
    [--equal(multiply(a,multiply(b,c)),multiply(multiply(a,b),c))]).
%--------------------------------------------------------------------------
