%--------------------------------------------------------------------------
% File     : GRP013=CmtrEqId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Commutator equals identity in these conditions
% Version  : [McCharen, et al., 1976] axioms.
% English  : If X.X=identity and if X^-1.Y^-1 = Z then X.Z = Y, then 
%            (X.Y).(X^-1.Y^-1) = identity.

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 11 [Wos, 1965]
%          : wos11 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   22 (   0 non-Horn)(  10 unit)
%            Number of literals          :   43 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   52 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(squareness,hypothesis,
    [++product(A,A,identity)]).

input_clause(a_times_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(inverse_a_times_inverse_b_is_d,hypothesis,
    [++product(inverse(a),inverse(b),d)]).

input_clause(inverses_have_property,hypothesis,
    [--product(inverse(A),inverse(B),C),
     ++product(A,C,B)]).

input_clause(prove_c_times_d_is_identity,theorem,
    [--product(c,d,identity)]).
%--------------------------------------------------------------------------
