%--------------------------------------------------------------------------
% File     : GRP012=InvOfProd-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Inverse of products = Product of inverses
% Version  : [McCharen, et al., 1976] (equality) axioms.
% English  : The inverse of products equals the product of the inverse, 
%            in opposite order

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   7 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   21 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : In Lemmas.eq.clauses of [ANL]
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include equality group theory axioms 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_inverse_of_product_is_product_of_inverses,theorem,
    [--equal(inverse(multiply(a,b)),multiply(inverse(b),inverse(a)))]).
%--------------------------------------------------------------------------
