%--------------------------------------------------------------------------
% File     : GRP012=InvOfProd-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Inverse of products = Product of inverses
% Version  : [McCharen, et al., 1976] axioms.
%            Theorem formulation : Expressed (X.Y)^-1 = X^-1.Y^-1.
% English  : The inverse of products equals the product of the inverse, 
%            in opposite order

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
% Source   : [ANL]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   18 (   0 non-Horn)(   7 unit)
%            Number of literals          :   38 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : In Lemmas.p.clauses on [ANL].
%--------------------------------------------------------------------------
%----Include equality axioms 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(prove_inverse_of_product_is_product_of_inverses,theorem,
    [--equal(inverse(multiply(a,b)),multiply(inverse(b),inverse(a)))]).
%--------------------------------------------------------------------------
