%--------------------------------------------------------------------------
% File     : GRP012=InvOfProd-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Inverse of products = Product of inverses
% Version  : [McCharen, et al., 1976] axioms.
%            Theorem formulation : Expressed as a.b = c and b^-1.a^-1 
%            = d, then c^-1 = d
% English  : The inverse of products equals the product of the inverse, 
%            in opposite order.

% Refs     : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : ls36 [Lawrence & Starkey, 1974]
%          : ls36 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(   9 unit)
%            Number of literals          :   40 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_mulitply_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(inverse_b_multiply_inverse_a_is_d,hypothesis,
    [++product(inverse(b),inverse(a),d)]).

input_clause(prove_c_inverse_equals_d,theorem,
    [--equal(inverse(c),d)]).
%--------------------------------------------------------------------------
