%--------------------------------------------------------------------------
% File     : GRP012=InvOfProd-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Inverse of products = Product of inverses
% Version  : [McCharen, et al., 1976] axioms.
%            Theorem formulation : Expressed as (X.Y).(Y^-1.X^-1) = id.
% English  : The inverse of products equals the product of the inverse, 
%            in opposite order.

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 9 [Wos, 1965]
%          : wos9 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(   9 unit)
%            Number of literals          :   40 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_mulitply_b_is_c,hypothesis,
    [++product(a,b,c)]).

input_clause(inverse_b_multiply_inverse_a_is_d,hypothesis,
    [++product(inverse(b),inverse(a),d)]).

input_clause(prove_c_mulitply_d_is_identity,theorem,
    [--product(c,d,identity)]).
%--------------------------------------------------------------------------
