%--------------------------------------------------------------------------
% File     : GRP011=LCanc-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Left cancellation
% Version  : [Wos, 1965] (equality) axioms : Incomplete.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 63 [Pelletier, 1986]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   19 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : Pelletier [1986] says "... problems, published I think, 
%            by Larry Wos (but I cannot locate where)."
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(inverse_substitution1,axiom,
    [--equal(D,E),
     ++equal(inverse(D),inverse(E))]).

input_clause(multiply_substitution1,axiom,
    [--equal(F,G),
     ++equal(multiply(F,H),multiply(G,H))]).

input_clause(multiply_substitution2,axiom,
    [--equal(I,J),
     ++equal(multiply(K,I),multiply(K,J))]).

%----The operation '*' is associative 
input_clause(associativity,axiom,
    [++equal(multiply(multiply(X,Y),Z),multiply(X,multiply(Y,Z)))]).

%----There exists an identity element 
input_clause(left_identity,axiom,
    [++equal(multiply(identity,X),X)]).

input_clause(left_inverse,axiom,
    [++equal(multiply(inverse(X),X),identity)]).

input_clause(product_equality,hypothesis,
    [++equal(multiply(b,c),multiply(d,c))]).

input_clause(prove_left_cancellation,theorem,
    [--equal(b,d)]).
%--------------------------------------------------------------------------
