%--------------------------------------------------------------------------
% File     : GRP009=LInvUnq-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : The left inverse of an element is unique
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 6 [Wos, 1965]
%          : wos6 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(   9 unit)
%            Number of literals          :   40 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_is_an_inverse_of_b,hypothesis,
    [++product(a,b,identity)]).

input_clause(c_is_an_inverse_of_b,hypothesis,
    [++product(c,b,identity)]).

input_clause(prove_a_equals_c,theorem,
    [--equal(a,c)]).
%--------------------------------------------------------------------------
