%--------------------------------------------------------------------------
% File     : GRP008=Unknown-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Unknown meaning
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 4 [Wos, 1965]
%          : wos4 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   24 (   1 non-Horn)(   7 unit)
%            Number of literals          :   54 (  21 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    5 (   1 constant)
%            Number of variables         :   59 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP003-0.ax').
%----Include group theory equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
%----These two substitution axioms are omitted in the original 
input_clause(h_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(h(A),h(B))]).

input_clause(j_substitutivity1,axiom,
    [--equal(C,D),
     ++equal(j(C),j(D))]).

input_clause(clause9,axiom,
    [--equal(A,B),
     --q(A),
     ++q(B)]).

input_clause(clause10,axiom,
    [--q(A),
     --product(A,B,C),
     ++product(B,A,C)]).

input_clause(clause12,axiom,
    [++product(j(A),A,h(A)),
     ++product(A,j(A),h(A)),
     ++q(A)]).

input_clause(clause15,axiom,
    [--product(j(A),A,h(A)),
     --product(A,j(A),h(A)),
     ++q(A)]).

input_clause(prove_identity_is_q,theorem,
    [--q(identity)]).
%--------------------------------------------------------------------------
