%--------------------------------------------------------------------------
% File     : GRP007=IdUnq-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : The identity element is unique
% Version  : [McCharen, et al., 1976] axioms.
% English  : 

% Refs     : Wos L.A. (1965), Unpublished notes, Argonne National 
%            Laboratory.
%          : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Problem 3 [Wos, 1965]
%          : wos3 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   20 (   0 non-Horn)(   9 unit)
%            Number of literals          :   40 (  17 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   50 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include group axioms 
include('Axioms/GRP003-0.ax').
%----Include group equality axioms 
include('Axioms/GRP003-0.eq').
%--------------------------------------------------------------------------
input_clause(another_left_identity,hypothesis,
    [++product(c,A,A)]).

input_clause(another_right_identity,hypothesis,
    [++product(A,c,A)]).

input_clause(prove_identity_equals_c,theorem,
    [--equal(identity,c)]).
%--------------------------------------------------------------------------
