%--------------------------------------------------------------------------
% File     : GRP006=InvEl-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Inverse is in this group
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : If S is a non-empty subset of a group such that 
%            if X, Y belong to S, the XY^-1 belongs to S, then S contains 
%            X^-1 whenever it contains X.

% Refs     : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Chang C.L., Lee R.C.T. (1973), Symbolic Logic and Mechanical 
%            Theorem Proving, Academic Press, New York.
% Source   : [Chang, 1970]
% Names    : Chang-Lee-6 [Chang, 1970]
%          : EX6 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :    9 (   0 non-Horn)(   6 unit)
%            Number of literals          :   18 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :   19 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(left_identity,axiom,
    [++product(identity,X,X)]).

input_clause(right_identity,axiom,
    [++product(X,identity,X)]).

input_clause(right_inverse,axiom,
    [++product(X,inverse(X),identity)]).

input_clause(left_inverse,axiom,
    [++product(inverse(X),X,identity)]).

input_clause(condition,axiom,
    [--an_element(X),
     --an_element(Y),
     --product(X,inverse(Y),Z),
     ++an_element(Z)]).

input_clause(associativity1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(element_of_set,hypothesis,
    [++an_element(b)]).

input_clause(prove_b_inverse_is_in_set,theorem,
    [--an_element(inverse(b))]).
%--------------------------------------------------------------------------
