%--------------------------------------------------------------------------
% File     : GRP003=LIdEqRId-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : The left identity is also a right identity
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : 

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Chang C.L., Lee R.C.T. (1973), Symbolic Logic and Mechanical 
%            Theorem Proving, Academic Press, New York.
% Source   : [Chang, 1970]
% Names    : Example 2 [Luckham, 1968]
%          : Chang-Lee-3 [Chang, 1970]
%          : EX3 [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :    5 (   0 non-Horn)(   3 unit)
%            Number of literals          :   11 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :   14 (   0 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(left_inverse,axiom,
    [++product(inverse(X),X,identity)]).

input_clause(left_identity,axiom,
    [++product(identity,X,X)]).

input_clause(associativity1,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(U,Z,W),
     ++product(X,V,W)]).

input_clause(associativity2,axiom,
    [--product(X,Y,U),
     --product(Y,Z,V),
     --product(X,V,W),
     ++product(U,Z,W)]).

input_clause(prove_there_is_a_right_identity,theorem,
    [--product(a,identity,a)]).
%--------------------------------------------------------------------------
