%--------------------------------------------------------------------------
% File     : GRP002=O3CmtrEqId-4 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Group Theory
% Problem  : Commutator equals identity in groups of order 3
% Version  : [McCharen, et al., 1976] (equality) axioms.
%            Theorem formulation : Explicit formulation of the commutator.
% English  : In a group, if (for all x) the cube of x is the identity 
%            (i.e. a group of order 3), then the equation [[x,y],y]= 
%            identity holds, where [x,y] is the product of x, y, the 
%            inverse of x and the inverse of y (i.e. the commutator 
%            of x and y).

% Refs     : McCharen J.D., Overbeek R.A., Wos L.A. (1976), Problems and 
%            Experiments for and with Automated Theorem Proving Programs, 
%            IEEE Transactions on Computers C-25(8), 773-782.
%          : Lusk E., and Overbeek R. (1985), Reasoning about Equality, 
%            Journal of Automated Reasoning 1(2), 209-228.
%          : Wos L. (1988), Automated Reasoning: 33 Basic Research 
%            Problems, Prentice-Hall.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
% Source   : [TPTP]
% Names    : Problem 4 [Lusk & Overbeek, 1985]
%          : Test Problem 2 [Wos, 1988]
%          : The Commutator Theorem [Wos, 1988]
%          : GT3 [Lusk & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   9 unit)
%            Number of literals          :   24 (  24 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   3 constant)
%            Number of variables         :   30 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include group theory axioms 
include('Axioms/GRP004-0.ax').
%--------------------------------------------------------------------------
%----Definition of the commutator 
input_clause(commutator,axiom,
    [++equal(commutator(X,Y),multiply(X,multiply(Y,multiply(inverse(X),
inverse(Y)))))]).

input_clause(commutator_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(commutator(A,C),commutator(B,C))]).

input_clause(commutator_substitutivity2,axiom,
    [--equal(D,E),
     ++equal(commutator(F,D),commutator(F,E))]).

input_clause(x_cubed_is_identity,hypothesis,
    [++equal(multiply(X,multiply(X,X)),identity)]).

input_clause(prove_commutator,theorem,
    [--equal(commutator(commutator(a,b),b),identity)]).
%--------------------------------------------------------------------------
